# User Defined Formulas

In the reports you can use formulas for complex things. There is also a wide range of functions to do this. But sometime you need more functions that are specific to your application. This is possible by writing these functions in Java yourself. This sample plugin demonstrates how you can do this.

## Activate the included plugin

In order to test this plugin, you need to copy the plugin ZIP file `customformulas.sample.zip` into the plugins folder of your installation or upload the plugin using Drag & Drop in the Store application. Afterwards the server needs to be restarted. You can check if the plugin was loaded in the dialog Store application. If there are problems, then check the log file of the server for more details.

To see the effect of the plugin:

  * start the designer (remote or local)
  * edit a formula
  * in the formula editor on the right side expand the tree node *User Defined Functions*
  * expand the tree node *`com.inet.samples.formula.FormulaSample`*
  * you see a list of functions
  * add one function with a double click to the current formula
  * correct the function parameters
  * run the report.

If you want to write your own formula functions then you simply need to create an instance of com.inet.report.formula.UserDefinedFunction.

## Server Plugin

In the next step you write your own server plugin. It must implement the interface `com.inet.plugin.ServerPlugin` and have an empty public constructor for loading. In the method `registerExtension` you must register all of your classes. This can look like:

```java
public void registerExtension( ServerPluginManager spm ) {
    spm.register( UserDefinedFunction.class, new MyFunction() );
}
```

Please refer to the sample `com.inet.samples.formula.FormulaSample` to see how this is done there.

## Build the plugin

The following steps need to be taken if changes are made to the plugin code.

The `plugin.properties` and server plugin class are preconfigured to be used without modifications. If the sample is the basis for a custom plugin or just needs some adaptions, please refer to the platform programming guide for detailed instructions.

### Collect the required jar files

In order to build this plugin the following jar files are required at minimum:

  * `inetcore.jar` (included in the `core` directory)
  * `reporting.jar` (included in the `plugins/reporting.zip` file)

These files are part of the SDK but will also be loaded from our public maven server when using the packaged `build.gradle`.

### Build the plugin

The plugin must be compiled into a jar file that is named like the id of the plugin. In this example it is `customformulas.sample.jar`. It also must contain the compiled sources as well as required language resources and images.

The target plugin is a zip file, named `customformulas.sample.zip` in this example. It contains the compiled jar file and the `plugin.properties` which configures the custom plugin.

The provided `build.gradle` in the sample can be used to build the plugin as well as any other build system.

## Deploying

Copy the ZIP file of the plugin into the plugins directory of the server or Drag & Drop the plugin into the Store application of the server for sideloading. Then restart the server. If there are problems, then check the log file of the server for more details. The "Config" logger is used to log plugin registration issues.

